/*
 * clGeniviAudioSource.cpp
 *
 *  Created on: Jul 25, 2013
 *      Author: vo84hi
 */
#include "IAmControlReceiverShadow.h"
#include "AudioStack/clGeniviAudioSource.h"
#include "AudioStack/AudioSources.h"
#include "AudioStack/clGeniviAudioCtrlAdapter.h"
#include "AudioStack/SMT/clSrcStateFactory.h"


using namespace am;

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clGeniviAudioSource.cpp.trc.h"
#endif

namespace AudioStack
{

   clGeniviAudioSource::clGeniviAudioSource(SourceID srcId) :
      clAudioSource(AudioSources::SourceName[srcId.enSourceClass], srcId),
      m_gam_handle(new am_Handle_s()),
      m_gam_connectionId(0)
   {
      am_SourceClass_s srcClass;
      am_sourceClass_t srcClassID = static_cast<am_sourceClass_t>(srcId.enSourceClass);
      srcClass.sourceClassID = srcClassID;
      srcClass.name          = std::string(AudioSources::SourceName[srcId.enSourceClass]);
      //This will fail for dynamic sources (
      clGeniviAudioCtrlAdapter::addSourceClass(srcClass, srcClassID);

      m_gam_source_s.domainID = clGeniviAudioCtrlAdapter::GetDomainID();
      m_gam_source_s.available.availability = A_AVAILABLE;
      m_gam_source_s.available.availabilityReason = AR_UNKNOWN;
      //TODO
      //move this to configuration -> StackRules Table!?

      //quickly avoid compiler warning
      //TODO make this more beautiful -> maybe in configuration!?
      am_MainSoundProperty_s msp = {MSP_MIC_STATUS_CONNECTION,0};
      m_gam_source_s.listMainSoundProperties.push_back(msp);
      am_MainSoundProperty_s msp_A = {MSP_MIC_STATUS_LEVEL,0};
      m_gam_source_s.listMainSoundProperties.push_back(msp_A);
      am_MainSoundProperty_s msp_B = {MSP_LEVEL_AUX_IN,0};
      m_gam_source_s.listMainSoundProperties.push_back(msp_B);

      m_gam_source_s.name = std::string(AudioSources::SourceName[srcId.enSourceClass]);
      if(m_StackRule.getRegistration() == clStackRules::registerStatic)
      {
         //For static source we'll provide a SourceID
         m_gam_source_s.sourceID = static_cast<am_sourceID_t>(srcId.enSourceClass); //take fixed ids to make thins easy
         am_Availability_s sAvail;
         sAvail.availabilityReason = AR_UNKNOWN;
         sAvail.availability = A_AVAILABLE;
         m_gam_source_s.visible = true;
         m_gam_source_s.available = sAvail;
      }

      //only when SubIDs are used we'll register with SubID(alias DeviceTag) as Genivi Name
      if(m_StackRule.getRegistration() == clStackRules::registerDynamic)
      {
         m_gam_source_s.sourceID = 0;
         const tU16 n = snprintf(NULL, 0, "#%d", srcId.u16SubSource);
         //ASSERT_NORMAL(n > 0)
         char buf[n+1];
         int c = snprintf(buf, n+1, "#%d", srcId.u16SubSource);
         //assert(buf[n] == '\0');
         //assert(c == n);
         m_gam_source_s.name.append(buf);
         m_gam_source_s.visible = true;
      }
      ETG_TRACE_USR4(("clGeniviAudioSource: Name %s", m_gam_source_s.name.c_str()));
      delete[] m_pacName;
      char *cstr = new char[m_gam_source_s.name.length() + 1];
      strcpy(cstr, m_gam_source_s.name.c_str());
      m_pacName = cstr;
      ETG_TRACE_USR4(("clAudioSource: Changed Name %s", pacGetName()));
      m_gam_source_s.sourceState = SS_OFF;
      m_gam_source_s.sourceClassID = srcId.enSourceClass;
      m_gam_source_s.volume = 0;
      m_gam_source_s.listConnectionFormats.push_back(CF_STEREO);
      // item.listMainSoundProperties.push_back(am_MainSoundProperty_s{MSP_MIC_STATUS_CONNECTION,0});
      // item.listMainSoundProperties.push_back(am_MainSoundProperty_s{MSP_MIC_STATUS_LEVEL,0});
      // item.listMainSoundProperties.push_back(am_MainSoundProperty_s{MSP_LEVEL_AUX_IN,0});

      m_gam_source_s.sourceID = clGeniviAudioCtrlAdapter::AddSource(m_SrcId, m_gam_source_s);
      ETG_TRACE_USR4(("clAudioSource: SourceClass: %d subID %#x(%d), GeniviID %d, Name %s"
            , ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(m_SrcId.enSourceClass))
            , (tU16)m_SrcId.u16SubSource
            , (tU16)m_SrcId.u16SubSource
            , m_gam_source_s.sourceID
            , pacGetName()));
   }

   clGeniviAudioSource::~clGeniviAudioSource()
   {
      clGeniviAudioCtrlAdapter::RemoveSource(m_gam_source_s.sourceID);
      delete(m_gam_handle);
   }

   void clGeniviAudioSource::vPrint()
   {
      ETG_TRACE_ERR(("%s", m_pacName));
      ETG_TRACE_ERR(("  | SourceClass: 0x%02x(%03d), SubID 0x%02x(%03d),"
         , m_SrcId.enSourceClass
         , m_SrcId.enSourceClass
         , m_SrcId.u16SubSource
         , m_SrcId.u16SubSource));
      ETG_TRACE_ERR(("  | MidwID 0x%02x(%03d)"
         , m_StackRule.getExternalID()
         , m_StackRule.getExternalID()));
      ETG_TRACE_ERR(("  | GeniviSrcID 0x%02x(%03d)"
         , m_gam_source_s.sourceID
         , m_gam_source_s.sourceID));
      ETG_TRACE_ERR(("  | State: %d", ETG_CENUM(AudioStates::enAudioStates, m_pclState->m_enStateID)));
      ETG_TRACE_ERR(("  | Availability: %d", ETG_CENUM(clAudioSource::enSourceAvailability, m_availability)));
      ETG_TRACE_ERR(("                "));
   }

   tVoid clGeniviAudioSource::vMW_CCAResponse(tS32 extSourceId, enSourceActivity activity)
   {
      switch(activity)
      {
         case clGeniviAudioSource::On:
            ETG_TRACE_ERR(("vMW_CCAResponse: On"));
            if( m_pclState == clSrcStateFactory::pclCreateRampUpRequesting())
            {
               clGeniviAudioCtrlAdapter::connect((*m_gam_handle), m_gam_connectionId,
                           CF_STEREO,
                           m_gam_source_s.sourceID,
                           static_cast<am_sinkID_t>(GAM_AUDIO_SINK_ID));
               clGeniviAudioCtrlAdapter::setSourceState(*m_gam_handle, m_gam_source_s.sourceID, SS_ON);
               std::vector<am_connectionID_t> connectionList;
               connectionList.push_back(m_gam_connectionId);
               clGeniviAudioCtrlAdapter::changeMainConnectionRouteDB(m_gam_source_s.sourceID, connectionList);
               clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID,GAM_AUDIO_SINK_ID,CS_CONNECTED);
               vMW_OnDone();
            }
            break;
         case clGeniviAudioSource::Pause:
            if( m_pclState == clSrcStateFactory::pclCreateRampDownToPause())
            {
               // All of them are synchronously
               clGeniviAudioCtrlAdapter::setSourceState(*m_gam_handle, m_gam_source_s.sourceID, SS_PAUSED);

               //VVD need not to disconnect,
               //clGeniviAudioCtrlAdapter::disconnect(*m_gam_handle, m_gam_connectionId);

               //VVD need not to remove, change it to CS_SUSPENDED
               //clGeniviAudioCtrlAdapter::removeMainConnectionDB(m_u8Id);
               clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID, static_cast<am_sinkID_t>(GAM_AUDIO_SINK_ID), CS_SUSPENDED);

               vMW_PauseDone();


            }
            break;
         case clGeniviAudioSource::Off:
            if( m_pclState == clSrcStateFactory::pclCreateRampDownToOff())
            {
               clGeniviAudioCtrlAdapter::setSourceState(*m_gam_handle, m_gam_source_s.sourceID, SS_OFF);
               clGeniviAudioCtrlAdapter::disconnect(*m_gam_handle, m_gam_connectionId);
               clGeniviAudioCtrlAdapter::removeMainConnection(m_gam_source_s.sourceID);
               vMW_OffDone();
            }
            break;
         default:
            break;
      }
   }

   tVoid clGeniviAudioSource::vMW_Pause(SourceID possibleNextSrc)
   {
      int ruleIndex = clStackRules::ruleIndex(possibleNextSrc);
      int extID = clStackRules::rules[ruleIndex].externalID;
      ETG_TRACE_USR4(("GAS vMW_Pause: SourceClass: %d subID %#x(%d), ExtId %#x(%d), PNSClass %d PNSsubID %#x(%d)"
                  ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(sGetId().enSourceClass))
                  , (tU16)sGetId().u16SubSource
                  , (tU16)sGetId().u16SubSource
                  ,getExternalId()
                  ,getExternalId()
                  ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(possibleNextSrc.enSourceClass))
                  ,possibleNextSrc.u16SubSource
                  ,possibleNextSrc.u16SubSource));
      clGeniviAudioCtrlAdapter::SourceActivityRequest(static_cast<midw_fi_tcl_e8_AudSource::tenType> (getExternalId())
                                                     ,static_cast<midw_fi_tcl_e8_AudSource::tenType> (extID)
                                                     ,midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE);
   }

   tVoid clGeniviAudioSource::vMW_Off(SourceID possibleNextSrc)
   {
      int ruleIndex = clStackRules::ruleIndex(possibleNextSrc);
      int extID = clStackRules::rules[ruleIndex].externalID;
      ETG_TRACE_USR4(("GAS vMW_Off: SourceClass: %d subID %#x(%d), ExtId %#x(%d), PNSClass %d PNSsubID %#x(%d)"
            ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(sGetId().enSourceClass))
            , (tU16)sGetId().u16SubSource
            , (tU16)sGetId().u16SubSource
            ,getExternalId()
            ,getExternalId()
            ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(possibleNextSrc.enSourceClass))
            ,possibleNextSrc.u16SubSource
            ,possibleNextSrc.u16SubSource));

      clGeniviAudioCtrlAdapter::SourceActivityRequest(static_cast<midw_fi_tcl_e8_AudSource::tenType> (getExternalId())
                                                     ,static_cast<midw_fi_tcl_e8_AudSource::tenType> (extID)
                                                     ,midw_fi_tcl_e8_SrcActivity::FI_EN_OFF);
      clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID,GAM_AUDIO_SINK_ID,CS_DISCONNECTING);
   }

   tVoid clGeniviAudioSource::vMW_On()
   {
      ETG_TRACE_USR4(("clGeniviAudioSource::vMW_On()"));
      am_mainConnectionID_t mainConnectionID;
      //Check if we have a MainConnection
      if(clGeniviAudioCtrlAdapter::getMainConnectionOfSource(m_gam_source_s.sourceID, mainConnectionID) != E_OK)
      {
         ETG_TRACE_USR4(("vMW_On(): Add MainConnection for Source %d", m_gam_source_s.sourceID));
         //e.g. restore LSM we need to add a connection initiation by our own
         am_Error_e retVal = clGeniviAudioCtrlAdapter::addMainConnection(m_gam_source_s.sourceID);
         if(retVal != E_OK)
         {
            ETG_TRACE_ERR(("vMW_On(): ERROR %d Add MainConnection for Source %d"
                  , ETG_CENUM(am::am_Error_e, retVal)
                  , m_gam_source_s.sourceID));
         }
      }
      // call connect to Genivi AudioManager

      clGeniviAudioCtrlAdapter::SourceActivityRequest(static_cast<midw_fi_tcl_e8_AudSource::tenType> (getExternalId())
                                                           ,static_cast<midw_fi_tcl_e8_AudSource::tenType> (getExternalId())
                                                           ,midw_fi_tcl_e8_SrcActivity::FI_EN_ON);
   }

   void clGeniviAudioSource::vReset()
   {
      ETG_TRACE_USR1(("vReset: Reset SourceClass: %d subID %#x(%d) "
            ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(m_SrcId.enSourceClass))
            , (tU16)m_SrcId.u16SubSource
            , (tU16)m_SrcId.u16SubSource));
      //TODO
      //remove Genivi Connections
      //remove Genivi MainConnection
      clGeniviAudioCtrlAdapter::removeMainConnection(m_gam_source_s.sourceID);
      //finally call reset within base class
      clAudioSource::vReset();
   }

   clAudioSource::enSourceAvailability clGeniviAudioSource::mapAvailability(am_Availability_e avail)
   {
      enSourceAvailability retVal = unkonwn;
      switch(avail)
      {
         case A_AVAILABLE:
            retVal = available;
            break;
         case A_UNAVAILABLE:
            retVal = not_available;
            break;
         case A_UNKNOWN:
            retVal = unkonwn;
            break;
         default:
            ETG_TRACE_FATAL(("clGeniviAudioSource::enIsSourceAvailable unkown value in m_gam_source_s.available.availability: %d",
                  avail));
            break;
      }
      return retVal;
   }

   am_Availability_e clGeniviAudioSource::mapAvailability(clAudioSource::enSourceAvailability avail)
   {
      for(tU16 i = static_cast<tU16>(A_MAX)-1; i!=0; --i)
      {
         if(mapAvailability(static_cast<am_Availability_e>(i)) ==  avail)
            return static_cast<am_Availability_e>(i);
      }
      ETG_TRACE_FATAL(("clGeniviAudioSource::enIsSourceAvailable unkown value in clAudioSource::enSourceAvailability: %d",
            avail));
      return A_UNKNOWN;
   }

   clAudioSource::enSourceAvailability clGeniviAudioSource::enIsSourceAvailable()
   {
      clAudioSource::enSourceAvailability retVal = mapAvailability(m_gam_source_s.available.availability);
      ETG_TRACE_USR4(("enIsSourceAvailable: SourceClass: %d subID %#x(%d) Available: %d"
               ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(m_SrcId.enSourceClass))
               , (tU16)m_SrcId.u16SubSource
               , (tU16)m_SrcId.u16SubSource
               , ETG_CENUM(enSourceAvailability, retVal)));
      return retVal;
   }

   tVoid clGeniviAudioSource::vSourceAvailablilityChange(enSourceAvailability availability,
         enSourceAvailabilityReason availabilityReason)
   {
      m_gam_source_s.available.availability = mapAvailability(availability);
      //Call base class implementation
      clAudioSource::vSourceAvailablilityChange(availability, availabilityReason);
      //Trigger remove of dynamic sources
      if((availability == clAudioSource::not_available)
         && (getRegistrationMode() == clStackRules::registerDynamic))
      {
         ETG_TRACE_USR1(("vSourceAvailablilityChange: Unregister Source at Genivi: SourceClass: %d subID %#x(%d)"
               ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(m_SrcId.enSourceClass))
               , (tU16)m_SrcId.u16SubSource
               , (tU16)m_SrcId.u16SubSource));
               clGeniviAudioCtrlAdapter::RemoveSource(m_gam_source_s.sourceID);
      }
   }


} //namespace


